#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Akiyoshi Snakes IllusionMod01.fsh  by Dave Hoskins
//https://www.shadertoy.com/view/XdXGWr
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// Akiyoshi's Snakes Illusion
// Shader code by David Hoskins - 2013.
// This is my attempt at recreating an "anomalous motion illusion" from here:-
// http://www.ritsumei.ac.jp/~akitaoka/index-e.html
// *** This should be viewed full screen to work correctly. ***
//
// It is NOT ANIMATED, it just seems like it is!
// It works by using psychovisual research into how the brain interprets images
// in the visual cortex - cool huh?!
// You can stop it by staring at a single point,
// Can't make it stop? Then you're drinking too much coffee!! :)
// CAT's can see it too! Look:-
// http://www.youtube.com/watch?v=CcXXQ6GCUb8

float Circle(vec2 p, float r)
{
    float ret = length(p)-r;    return ret;
}

vec3 Colour(vec2 pos, float r, float odd)
{
    if (r > .235) return vec3(0.0, 0.0, 0.0);
    vec3 rgb;
    r = pow(r, 1.5)*90.0;
    float ring = floor(r);
    r = pow(fract(r), 1.0/1.5);
    float ang = atan(pos.x,pos.y)*6.37;
    ang += ring;
    float fra = fract(ang);
    float si = length(vec2(fra*1.25, r)-vec2(.5, .5))-.5;
    if (si <= 0.0)
    {
        rgb = mix(vec3(.825, .825, 0.0), vec3(0.0, 0.399, 1.0), step(mod(ang+odd, 2.0), 1.0));
    }
    else
    {
        rgb = mix(vec3(.0, .0, 0.0), vec3(1.0, 1.0, 1.0), step(mod(ang+.5, 2.0), 1.0));
    }
    return rgb;
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    vec2 uv = (fragCoord.xy / iResolution.xy)*2.0-1.0;
    uv *= .85;
    uv.x *= iResolution.x / iResolution.y;
    vec2 pixelSize = vec2(1.0, 1.0) / iResolution.xy;
    vec3 rgb;
    vec3 colAdd = vec3(0.0, 0.0, 0.0);
    float r;

    // Anti-aliasing...
    float y = -1.0;
    for (int yi = 0; yi < 4; yi++)
    {
        float x = -1.0;
        for (int xi = 0; xi < 4; xi++)
        {
            rgb = vec3(1.0, 1.0, 1.0);
            vec2 pos = uv+vec2(0.0, .25)+pixelSize*vec2(x, y)+.5;
            float odd = mod(floor(pos.x*2.0)+floor(pos.y*2.0),2.0);                    
            if (length(max(abs(uv*vec2(.5, 1.0))-.75,0.0)) <= .0)            
            {                
                pos = mod(pos, .5)-.25;                
                r = Circle(pos, .25);                
                if (r < 0.0)                
                {                    
                    rgb = Colour(pos, -r, odd);                
                }            
            }            
            if (length(max(abs(uv*vec2(.4, 1.0))-.5,0.0)) <= .0)            
            {                
                pos = uv+vec2(0.0, .25)+pixelSize*vec2(x, y)+.25;                
                float odd = mod(floor(pos.x*2.0)+floor(pos.y*2.0),2.0);                
                pos = mod(pos, .5)-.25;                
                r = Circle(pos, .25);                
                if (r < 0.0)                
                {                    
                    rgb = Colour(pos, -r, odd);
                }            
            }            
            colAdd += rgb;            
            x += .5;        
        }        
        y += .5;    
    }    
    colAdd *= 1.0/16.0;        
    fragColor = vec4(colAdd, 1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

